#include "MAC57D54H.h"
#include <stdio.h>
#include "m4_cache.h"
#include "halo_ports.h"

#include "illuminations.h"

void setup_illuminations()
{
  TFT_backlight_enable();
  needle_backlight_enable();
}

void set_pdo(int pin, int value){

	char *gpdo = (char *)0x400dd300;
	if((pin&0x3)==0) pin+=3;
	else if((pin&0x3)==1) pin+=1;
	else if((pin&0x3)==2) pin-=1;
	else pin-=3;
	gpdo[pin] = value;
}

void TFT_backlight_enable()
{
  /* configures back light to 27kHz (max as per spec) */
  
  //set the enable and the pwm pins here
}
 
void needle_backlight_enable()
{

#if 1
#define BACKLIGHT_EN  PM0
#define BACKLIGHT_PWM PM1
     SIUL2.MSCR[BACKLIGHT_EN].B.OBE = 1; 
     SIUL2.GPDO[44].B.PDO_4n = 1; // PM0/4 = 44
     SIUL2.MSCR[BACKLIGHT_PWM].B.OBE = 1; 
     SIUL2.GPDO[44].B.PDO_4n1 = 1;
   
#endif
	


  /* currently these are set as GPIO and enabled, although they could easily be configured as PWMs
     using the Flextimer in future */
	SIUL2.MSCR[PC13].B.OBE = 1;
	set_pdo(PC13, 1);

	SIUL2.MSCR[PC12].B.OBE = 1;
	set_pdo(PC12, 1);
	
	SIUL2.MSCR[PC10].B.OBE = 1;
	set_pdo(PC10, 1);

	SIUL2.MSCR[PC11].B.OBE = 1;
	set_pdo(PC11, 1);
	
}

#define LED_CLK_DELAY 0x0
// should be able to remomve the dealy entirely as steady clock should not be required so long as edges align. Need to test to confirm.

/* LED functions:
LED_init() run first to set up GPIO 

set_left_led(uint8_t temp, uint8_t red_segments) set temp (valid: 0 is all off and 1-8) and reg_segments (valid: 0-9)
set_right_led(uint8_t fuel) set fuel (valid: 0 is all off, 1-8)
set_centre_led(uint16_t telltale); telltale gives value of what to set. See LED.txt for list of bits vs LEDS 

List of LEDs vs bit available in LED.txt
*/


const int center_leds[] = {PF1,PF2,PE15,PF0,PE13,PE14,PE11,PE12,PL14,PL13,PL12,PL11,PL10,PL9,PL8,PL7};
void LED_init()
 {
	int i;
	/***** Configure pins *****/
	/* configure outputs for LED Center */
	for(i = 0; i<16; i++) SIUL2.MSCR[center_leds[i]].B.OBE = 1;

	/* configure outputs for LED Left */
	SIUL2.MSCR[PC7].B.OBE = 1;	/* GPIO - Left-Strobe */
	SIUL2.MSCR[PC6].B.OBE = 1;	/* GPIO - Left-CLK */
	SIUL2.MSCR[PC5].B.OBE = 1; 	/* GPIO - Left-Data */
	SIUL2.MSCR[PC4].B.OBE = 1;	/* GPIO - Left-output enable */

	/* configure outputs for LED Right */
	SIUL2.MSCR[PC0].B.OBE = 1;	/* GPIO - Right-Strobe */
	SIUL2.MSCR[PC2].B.OBE = 1;	/* GPIO - Right-CLK */
	SIUL2.MSCR[PC3].B.OBE = 1; 	/* GPIO - Right-Data */
	SIUL2.MSCR[PC1].B.OBE = 1;	/* GPIO - Right-output enable */
	/************************/
}



void set_centre_led(uint16_t telltale)
{
	uint16_t centre_LED_value = 0x5555;
	uint32_t i,j;
	centre_LED_value = telltale;
	
	/* program 16 bit data */
	for (i=0;i<16;i++)
	{
		set_pdo(center_leds[i], ((centre_LED_value>>i)&0x1));
	}
}



void set_left_led(uint8_t temp, uint8_t red_segments)
{
	uint32_t left_LED_value = 0; //0xffffffff
	uint32_t i,j;
	
	switch(temp){
	case 0 :
		left_LED_value |= 0x0;
		break;
	case 1 :
		left_LED_value |= 0x2;
		break;
	case 2 :
		left_LED_value |= 0x6;
		break;
	case 3 :
		left_LED_value |= 0xe;
		break;
	case 4 :
		left_LED_value |= 0x1e;
		break;
	case 5 :
		left_LED_value |= 0x9e;
		break;
	case 6 :
		left_LED_value |= 0xde;
		break;
	case 7 :
		left_LED_value |= 0xfe;
		break;
	case 8 :
		left_LED_value |= 0xff;
		break;
	default :
		while(1); // error - invalid input - temp must be between 1 and 8 
	}
	
	
	switch(red_segments)
	{
		case 0 :
			left_LED_value |= 0x00000;
			break;
		case 1 :
			left_LED_value |= 0x10000;
			break;
		case 2 :
			left_LED_value |= 0x30000;
			break;
		case 3 :
			left_LED_value |= 0x70000;
			break;
		case 4 :
			left_LED_value |= 0xf0000;
			break;
		case 5 :
			left_LED_value |= 0xf8000;
			break;
		case 6 :
			left_LED_value |= 0xfc000;
			break;
		case 7 :
			left_LED_value |= 0xfe000;
			break;
		case 8 :
			left_LED_value |= 0xff000;
			break;
		case 9 :
			left_LED_value |= 0xff800;
			break;
		default :
			while(1); // error - invalid input - segments must be between 0 and 9 
	}
	

	/* program 32 bit data */
	for (i=0;i<32;i++)
	{
		//reg32_write(GPIOC_PCOR, LEFT_LED_CLK); /* -ve edge  */
		set_pdo(PC6, 0);
		/* load bit */
		if((left_LED_value>>i)&0x1)
			//reg32_write(GPIOC_PSOR, LEFT_LED_DATA); /* set data bit */
			set_pdo(PC5, 1);
		else
			//reg32_write(GPIOC_PCOR, LEFT_LED_DATA); /* clear data bit */
			set_pdo(PC5, 0);
			
	//for(j=0;j<LED_CLK_DELAY;j++); /* wait */
		//reg32_write(GPIOC_PSOR, LEFT_LED_CLK); /* +ve edge */
		set_pdo(PC6, 1);
	//for(j=0;j<LED_CLK_DELAY;j++); /* wait */
	}
	//reg32_write(GPIOC_PCOR, LEFT_LED_CLK); /* -ve edge  */
	set_pdo(PC6, 0);
	//reg32_write(GPIOC_PSOR, LEFT_LED_STROBE); /* input complete - set strobe */
	set_pdo(PC7, 1);
	//for(j=0;j<LED_CLK_DELAY;j++); /* wait */
	//reg32_write(GPIOC_PCOR, LEFT_LED_STROBE); /* clear strobe */
	set_pdo(PC7, 0);
	/* enable output (set output enable)  */
	//reg32_write(GPIOC_PSOR, LEFT_LED_OUT_EN);
	set_pdo(PC4, 1);
}
	
#if 1	
	
void set_right_led(uint8_t fuel)
{
	/* RIGHT */  
	unsigned long long right_LED_value = 0;//0x00FFFFFFFFFFFFFF;
	uint32_t i,j;
	
	switch(fuel)
	{
		case 0 :
			right_LED_value |= 0;
			break;
		case 1 :
			right_LED_value |= 0x8;
			break;
		case 2 :
			right_LED_value |= 0xC00;
			break;
		case 3 :
			right_LED_value |= 0xe00;
			break;
		case 4 :
			right_LED_value |= 0xf00;
			break;
		case 5 :
			right_LED_value |= 0x1f00;
			break;
		case 6 :
			right_LED_value |= 0x3f00;
			break;
		case 7 :
			right_LED_value |= 0x7f00;
			break;
		case 8 :
			right_LED_value |= 0xff00;
			break;
		default :
			while(1); /* error - invalid input - temp must be between 1 and 8 */
	}
	
	
	/* program 56 bit data */
	for (i=0;i<56;i++)
	{
	//reg32_write(GPIOB_PCOR, RIGHT_LED_CLK); /* -ve edge  */
	set_pdo(PC2, 0);
	/* load bit */
	if((right_LED_value>>i)&0x1)
			//reg32_write(GPIOC_PSOR, LEFT_LED_DATA); /* set data bit */
			set_pdo(PC3, 1);
		else
			//reg32_write(GPIOC_PCOR, LEFT_LED_DATA); /* clear data bit */
			set_pdo(PC3, 0);
	//reg32_write(GPIOB_PSOR, RIGHT_LED_CLK); /* +ve edge */
			set_pdo(PC2, 1);
	//for(j=0;j<LED_CLK_DELAY;j++); /* wait */
	}
	//reg32_write(GPIOC_PCOR, LEFT_LED_CLK); /* -ve edge  */
	set_pdo(PC2, 0);
	//reg32_write(GPIOC_PSOR, LEFT_LED_STROBE); /* input complete - set strobe */
	set_pdo(PC0, 1);
	//for(j=0;j<LED_CLK_DELAY;j++); /* wait */
	//reg32_write(GPIOC_PCOR, LEFT_LED_STROBE); /* clear strobe */
	set_pdo(PC0, 0);
	/* enable output (set output enable)  */
	//reg32_write(GPIOC_PSOR, LEFT_LED_OUT_EN);
	set_pdo(PC1, 1);
}

#endif